/*
 * Decompiled with CFR 0.152.
 */
package com.yollo.dmlreforged.common.items;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import com.yollo.dmlreforged.DeepMobLearning;
import com.yollo.dmlreforged.core.GlitchToolMaterial;
import com.yollo.dmlreforged.core.util.NBTHelper;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import net.minecraft.ChatFormatting;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;

public class ItemGlitchSword
extends SwordItem {
    private static final int DAMAGE_BONUS = 1;
    private static final int DAMAGE_BONUS_MAX = 32;
    private static final int DAMAGE_INCREASE_CHANCE = 4;

    public ItemGlitchSword() {
        super((Tier)new GlitchToolMaterial(), 10, 5.0f, new Item.Properties().m_41491_(DeepMobLearning.Deep_Mob_Learning_TAB));
    }

    public static boolean canIncreaseDamage(ItemStack sword) {
        return ItemGlitchSword.getPermanentWeaponDamage(sword) < 32;
    }

    public static void increaseDamage(ItemStack sword, ServerPlayer player) {
        if (ThreadLocalRandom.current().nextInt(1, 100) <= 4) {
            int current = ItemGlitchSword.getPermanentWeaponDamage(sword);
            ItemGlitchSword.setPermanentWeaponDamage(sword, current + 1 >= 32 ? 32 : current + 1);
            if (ItemGlitchSword.getPermanentWeaponDamage(sword) >= 32) {
                player.m_5661_((Component)new TranslatableComponent("dmlreforged.messages.sword_levelup.max", new Object[]{new TextComponent(sword.m_41786_().getString()).m_130938_(t -> t.m_131140_(ChatFormatting.AQUA))}), true);
            } else {
                player.m_5661_((Component)new TranslatableComponent("dmlreforged.messages.sword_levelup", new Object[]{new TextComponent(sword.m_41786_().getString()).m_130938_(t -> t.m_131140_(ChatFormatting.AQUA))}), true);
            }
        }
    }

    public static int getPermanentWeaponDamage(ItemStack stack) {
        return NBTHelper.getInt(stack, "permDamage", 0);
    }

    public static void setPermanentWeaponDamage(ItemStack stack, int damage) {
        NBTHelper.setInt(stack, "permDamage", damage);
    }

    public Multimap<Attribute, AttributeModifier> getAttributeModifiers(EquipmentSlot slot, ItemStack stack) {
        HashMultimap modifiers = HashMultimap.create();
        if (slot == EquipmentSlot.MAINHAND) {
            modifiers.put((Object)Attributes.f_22281_, (Object)new AttributeModifier(f_41374_, "Weapon modifier", (double)(this.m_43314_().m_6631_() + (float)ItemGlitchSword.getPermanentWeaponDamage(stack)), AttributeModifier.Operation.ADDITION));
            modifiers.put((Object)Attributes.f_22283_, (Object)new AttributeModifier(f_41375_, "Weapon modifier", (double)-2.4f, AttributeModifier.Operation.ADDITION));
        }
        return modifiers;
    }

    public void m_7373_(ItemStack stack, Level level, List<Component> list, TooltipFlag flag) {
        list.add((Component)new TranslatableComponent("dmlreforged.hover_text.glitch_infused_sword_1"));
        list.add((Component)new TranslatableComponent("dmlreforged.hover_text.glitch_infused_sword_3").m_130938_(t -> t.m_131140_(ChatFormatting.GOLD)));
        list.add((Component)new TranslatableComponent("dmlreforged.hover_text.glitch_infused_sword_4").m_130938_(t -> t.m_131140_(ChatFormatting.GOLD)));
        list.add((Component)new TranslatableComponent("dmlreforged.hover_text.glitch_infused_sword_5").m_130938_(t -> t.m_131140_(ChatFormatting.GOLD)));
        list.add((Component)new TextComponent(""));
        list.add((Component)new TranslatableComponent("dmlreforged.hover_text.glitch_infused_sword_6", new Object[]{new TextComponent(Integer.toString(ItemGlitchSword.getPermanentWeaponDamage(stack))).m_130938_(t -> t.m_131140_(ChatFormatting.AQUA)), new TextComponent(Integer.toString(32)).m_130938_(t -> t.m_131140_(ChatFormatting.WHITE))}).m_130938_(t -> t.m_131140_(ChatFormatting.GRAY)));
    }

    public Component m_7626_(ItemStack p_41458_) {
        return new TranslatableComponent(super.m_7626_(p_41458_).getString()).m_130938_(t -> t.m_131140_(ChatFormatting.AQUA));
    }
}

